/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_331445 {
    @Test
    public void testBug() throws CoreException, URISyntaxException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String variableName = "a" + ResourceTestUtil.createUniqueString();
        String variablePath = "mem:/MyProject";
        String folderName = "MyFolder";
        String rawLinkFolderLocation = variableName + "/" + folderName;
        String linkFolderLocation = variablePath + "/" + folderName;
        project.getPathVariableManager().setURIValue(variableName, new URI(variablePath));
        IFolder folder = project.getFolder(ResourceTestUtil.createUniqueString());
        folder.createLink(IPath.fromOSString((String)rawLinkFolderLocation), 16, ResourceTestUtil.createTestMonitor());
        Assertions.assertNull((Object)folder.getLocation());
        Assertions.assertEquals((Object)IPath.fromOSString((String)rawLinkFolderLocation), (Object)folder.getRawLocation());
        Assertions.assertEquals((Object)new URI(linkFolderLocation), (Object)folder.getLocationURI());
        Assertions.assertEquals((Object)new URI(rawLinkFolderLocation), (Object)folder.getRawLocationURI());
    }
}

