/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Function;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileStore;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_332543 {
    @AfterEach
    public void tearDown() {
        WrapperFileSystem.setCustomFileStore(null);
    }

    @Test
    public void testBugForByteArrayInputStream() throws Exception {
        this.testCancel(s -> s);
    }

    @Test
    public void testBugForInputStream() throws Exception {
        this.testCancel(delegate -> new InputStream((ByteArrayInputStream)delegate){
            private final /* synthetic */ ByteArrayInputStream val$delegate;
            {
                this.val$delegate = byteArrayInputStream;
            }

            @Override
            public int read() throws IOException {
                return this.val$delegate.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.val$delegate.read(b, off, len);
            }
        });
    }

    private void testCancel(Function<ByteArrayInputStream, InputStream> wrap) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String proj_name = ResourceTestUtil.createUniqueString();
        IPath proj_loc = root.getLocation().append(proj_name);
        URI proj_uri = WrapperFileSystem.getWrappedURI(URIUtil.toURI((IPath)proj_loc));
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(proj_name);
        desc.setLocationURI(proj_uri);
        IProject project = root.getProject(desc.getName());
        project.create(desc, ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("foo.txt");
        ResourceTestUtil.createInFileSystem((IResource)file);
        project.open(ResourceTestUtil.createTestMonitor());
        WrapperFileSystem.setCustomFileStore(IOErrOnCloseFileStore.class);
        Assertions.assertThrows(CoreException.class, () -> file.setContents((InputStream)wrap.apply(new ByteArrayInputStream("Random".getBytes())), false, true, ResourceTestUtil.createTestMonitor()));
        IFile nonExistentFile = project.getFile("foo1.txt");
        Assertions.assertThrows(CoreException.class, () -> nonExistentFile.create((InputStream)wrap.apply(new ByteArrayInputStream("Random".getBytes())), false, ResourceTestUtil.createTestMonitor()));
    }

    public static class IOErrOnCloseFileStore
    extends WrapperFileStore {
        public IOErrOnCloseFileStore(IFileStore store) {
            super(store);
        }

        @Override
        public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
            OutputStream os = super.openOutputStream(options, monitor);
            os = new BufferedOutputStream(os){

                @Override
                public void close() throws IOException {
                    super.close();
                    throw new IOException("Whoops I dunno how to close!");
                }
            };
            return os;
        }
    }
}

