/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.concurrent.Semaphore;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_378156 {
    @Test
    public void testBugTwoThreads() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project1 = root.getProject("Bug_378156");
        IFile file = project1.getFile("content.txt");
        ResourceTestUtil.createInWorkspace((IResource)project1);
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.sigbuilder").apply();
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        Thread.sleep(2000L);
        ResourceTestUtil.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project1);
        builder.reset();
        Semaphore semaphore = new Semaphore(0);
        ModifyFileJob runningJob = new ModifyFileJob(file, semaphore);
        runningJob.setRule((ISchedulingRule)file);
        runningJob.schedule();
        ModifyFileJob waitingJob = new ModifyFileJob(file, semaphore);
        waitingJob.setCancel();
        waitingJob.schedule();
        waitingJob.join();
        semaphore.release();
        runningJob.join();
        ResourceTestUtil.waitForBuild();
        Assertions.assertThat((Object)((Object)builder)).matches(SignaledBuilder::wasExecuted, "was executed");
    }

    @Test
    public void testBugOneThread() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project1 = root.getProject("Bug_378156");
        IFile file = project1.getFile("content.txt");
        ResourceTestUtil.createInWorkspace((IResource)project1);
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.sigbuilder").apply();
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        ResourceTestUtil.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project1);
        builder.reset();
        ResourcesPlugin.getWorkspace().run(monitor -> {
            file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, null);
            try {
                ResourcesPlugin.getWorkspace().run(monitor1 -> {
                    throw new OperationCanceledException();
                }, null);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }, null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertThat((Object)((Object)builder)).matches(SignaledBuilder::wasExecuted, "was executed");
    }

    class ModifyFileJob
    extends WorkspaceJob {
        private boolean cancel;
        private final IFile jobFile;
        private final Semaphore jobFlag;

        public ModifyFileJob(IFile file, Semaphore semaphore) {
            super("Modifying " + String.valueOf(file));
            this.jobFlag = semaphore;
            this.jobFile = file;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this.cancel) {
                throw new OperationCanceledException();
            }
            this.jobFile.setContents(ResourceTestUtil.createRandomContentsStream(), 0, null);
            try {
                this.jobFlag.acquire();
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.resources", "Failed to acquire job flag log", (Throwable)e));
            }
            return Status.OK_STATUS;
        }

        public void setCancel() {
            this.cancel = true;
        }
    }
}

