/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileNativesManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_530868 {
    private IProject testProject;
    private IFile testFile;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(Bug_530868.class) + "TestProject");
        this.testProject.create(ResourceTestUtil.createTestMonitor());
        this.testProject.open(ResourceTestUtil.createTestMonitor());
        this.testFile = this.testProject.getFile(((Method)testInfo.getTestMethod().get()).getName());
    }

    @Test
    public void testMillisecondResolution() throws Exception {
        Assume.assumeFalse((String)"not relevant on Mac, as it does not have milliseconds resolution", (boolean)Platform.OS.isMac());
        try {
            long timestamp1 = this.modifyTestFileAndFetchTimestamp("some contents 1");
            Thread.sleep(50L);
            long timestamp2 = this.modifyTestFileAndFetchTimestamp("some contents 2");
            Thread.sleep(50L);
            long timestamp3 = this.modifyTestFileAndFetchTimestamp("some contents 3");
            String failMessage = "expected different timestamps for modifications in quick succession";
            Assertions.assertNotEquals((long)timestamp1, (long)timestamp2, (String)failMessage);
            Assertions.assertNotEquals((long)timestamp2, (long)timestamp3, (String)failMessage);
        }
        finally {
            LocalFileNativesManager.reset();
        }
    }

    private long modifyTestFileAndFetchTimestamp(String contents) throws Exception {
        this.setTestFileContents(contents);
        long timestamp = this.getLastModificationTimestamp();
        return timestamp;
    }

    private void setTestFileContents(String contents) throws Exception {
        ByteArrayInputStream contentsStream = new ByteArrayInputStream(String.valueOf(contents).getBytes());
        if (this.testFile.exists()) {
            this.testFile.delete(true, ResourceTestUtil.createTestMonitor());
        }
        this.testFile.create((InputStream)contentsStream, true, ResourceTestUtil.createTestMonitor());
    }

    private long getLastModificationTimestamp() {
        IPath testFileLocation = this.testFile.getLocation();
        String filePath = testFileLocation.toOSString();
        FileInfo testFileInfo = LocalFileNativesManager.fetchFileInfo((String)filePath);
        return testFileInfo.getLastModified();
    }
}

