/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IFileTest {
    @Test
    @Disabled(value="This test is no longer valid since the error code is dependent on whether or not the parent folder is marked as read-only. We need to write a different test to make the file.create fail.")
    public void testBug25658() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting read-only files", (boolean)ResourceTestUtil.isReadOnlySupported());
        Assume.assumeFalse((String)"not relevant on Windows", (boolean)Platform.OS.isWindows());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder});
        IFile file = folder.getFile("file.txt");
        try {
            folder.setReadOnly(true);
            Assertions.assertThat((Object)folder).matches(IResource::isReadOnly, "is read only");
            CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor()));
            org.junit.jupiter.api.Assertions.assertEquals((int)272, (int)exception.getStatus().getCode());
        }
        finally {
            folder.setReadOnly(false);
        }
    }

    @Test
    public void testBug25662() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting read-only files", (boolean)ResourceTestUtil.isReadOnlySupported());
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder});
        IFile file = folder.getFile("file.txt");
        try {
            folder.setReadOnly(true);
            Assertions.assertThat((Object)folder).matches(IResource::isReadOnly, "is read only");
            CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor()));
            org.junit.jupiter.api.Assertions.assertEquals((int)277, (int)exception.getStatus().getCode());
        }
        finally {
            folder.setReadOnly(false);
        }
    }

    @Test
    public void testBug43936() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile descFile = project.getFile(".project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        Assertions.assertThat((Object)descFile).matches(IResource::exists, "exists");
        IProjectDescription desc = project.getDescription();
        long newTime = System.currentTimeMillis() + 10000L;
        descFile.setLocalTimeStamp(newTime);
        Assertions.assertThat((Object)descFile).matches(it -> it.isSynchronized(0), "is synchronized");
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
    }
}

