/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IFolderTest {
    @Test
    public void testBug25662() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting read-only files", (boolean)ResourceTestUtil.isReadOnlySupported());
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder parentFolder = project.getFolder("parentFolder");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, parentFolder});
        IFolder folder = parentFolder.getFolder("folder");
        try {
            parentFolder.setReadOnly(true);
            Assertions.assertThat((Object)parentFolder).matches(IResource::isReadOnly, "is read only");
            CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.create(true, true, ResourceTestUtil.createTestMonitor()));
            org.junit.jupiter.api.Assertions.assertEquals((int)277, (int)exception.getStatus().getCode());
        }
        finally {
            parentFolder.setReadOnly(false);
        }
    }

    @Test
    public void testBug11510() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("TestProject");
        IFolder folder = project.getFolder("fold1");
        IFile subFile = folder.getFile("f1");
        IFile file = project.getFile("f2");
        ResourceTestUtil.createInWorkspace((IResource)project);
        folder.create(true, false, ResourceTestUtil.createTestMonitor());
        file.create(null, true, ResourceTestUtil.createTestMonitor());
        subFile.create(null, true, ResourceTestUtil.createTestMonitor());
        Predicate<IResource> isLocal = resource -> resource.isLocal(0);
        Assertions.assertThat((Object)folder).matches(Predicate.not(isLocal), "not is local");
        Assertions.assertThat((Object)file).matches(Predicate.not(isLocal), "not is local");
        Assertions.assertThat((Object)subFile).matches(Predicate.not(isLocal), "not is local");
        ResourceTestUtil.createInFileSystem((IResource)file);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)file).matches(isLocal, "is local");
        Assertions.assertThat((Object)folder).matches(Predicate.not(isLocal), "not is local");
        Assertions.assertThat((Object)subFile).matches(Predicate.not(isLocal), "not is local");
        folder.getLocation().toFile().mkdir();
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)folder).matches(isLocal, "is local");
        Assertions.assertThat((Object)file).matches(isLocal, "is local");
        Assertions.assertThat((Object)subFile).matches(Predicate.not(isLocal), "not is local");
        ResourceTestUtil.createInFileSystem((IResource)subFile);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)folder).matches(isLocal, "is local");
        Assertions.assertThat((Object)file).matches(isLocal, "is local");
        Assertions.assertThat((Object)subFile).matches(isLocal, "is local");
    }

    @Test
    public void testBug514831() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("TestProject");
        IFolder folder = project.getFolder("folder");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(new IResource[]{folder});
        IFileStore dir = EFS.getLocalFileSystem().fromLocalFile(folder.getLocation().toFile());
        Assertions.assertThat((Object)dir).matches(it -> it.fetchInfo().exists(), "exists");
        dir.mkdir(0, null);
        dir.mkdir(4, null);
    }
}

