/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IProjectTest {
    @Test
    public void test_1G0XIMA() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        IResourceVisitor renameVisitor = resource -> {
            if (!resource.exists()) {
                return false;
            }
            IPath path = resource.getFullPath();
            path = path.removeLastSegments(1);
            long timestamp = System.currentTimeMillis();
            path = path.append(resource.getName() + " renamed at " + timestamp);
            resource.move(path, false, null);
            return true;
        };
        project.accept(renameVisitor);
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void test_1G5I6PV() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        project.setLocal(true, 0, ResourceTestUtil.createTestMonitor());
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testAutoBuild_1GC2FKV() throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(false);
        ResourcesPlugin.getWorkspace().setDescription(description);
        IProject projectONE = ResourcesPlugin.getWorkspace().getRoot().getProject("Project_ONE");
        IProjectDescription prjDescription = ResourcesPlugin.getWorkspace().newProjectDescription("ProjectONE");
        ICommand command = prjDescription.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
        prjDescription.setBuildSpec(new ICommand[]{command});
        projectONE.create(prjDescription, ResourceTestUtil.createTestMonitor());
        projectONE.open(ResourceTestUtil.createTestMonitor());
        IProject projectTWO = ResourcesPlugin.getWorkspace().getRoot().getProject("Project_TWO");
        prjDescription = ResourcesPlugin.getWorkspace().newProjectDescription("Project_TWO");
        command = prjDescription.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
        prjDescription.setBuildSpec(new ICommand[]{command});
        projectTWO.create(prjDescription, ResourceTestUtil.createTestMonitor());
        projectTWO.open(ResourceTestUtil.createTestMonitor());
        description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(true);
        ResourcesPlugin.getWorkspace().setDescription(description);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SignaledBuilder projectONEbuilder = SignaledBuilder.getInstance(projectONE);
        SignaledBuilder projectTWObuilder = SignaledBuilder.getInstance(projectTWO);
        projectONEbuilder.reset();
        projectTWObuilder.reset();
        projectONE.build(6, null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertThat((Object)((Object)projectONEbuilder)).matches(SignaledBuilder::wasExecuted, "was executed");
        Assertions.assertThat((Object)((Object)projectTWObuilder)).matches(Predicate.not(SignaledBuilder::wasExecuted), "was not executed");
        projectONEbuilder.reset();
        projectTWObuilder.reset();
        projectTWO.build(6, "org.eclipse.core.tests.resources.sigbuilder", null, null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertThat((Object)((Object)projectONEbuilder)).matches(Predicate.not(SignaledBuilder::wasExecuted), "was not executed");
        Assertions.assertThat((Object)((Object)projectTWObuilder)).matches(SignaledBuilder::wasExecuted, "was executed");
        projectONEbuilder.reset();
        projectTWObuilder.reset();
        projectTWO.touch(null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertThat((Object)((Object)projectONEbuilder)).matches(Predicate.not(SignaledBuilder::wasExecuted), "was not executed");
        Assertions.assertThat((Object)((Object)projectTWObuilder)).matches(SignaledBuilder::wasExecuted, "was executed");
    }

    @Test
    public void testBug78711() throws Exception {
        String name = ResourceTestUtil.createUniqueString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IFolder folder = project.getFolder("folder");
        IFile file1 = project.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IPath location = Platform.getLocation().append(project.getFullPath());
        location.toFile().mkdirs();
        location.append(folder.getName()).toFile().mkdirs();
        ResourceTestUtil.createInFileSystem(location.append(folder.getName()).append(file2.getName()));
        ResourceTestUtil.createInFileSystem(location.append(file1.getName()));
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(IResource::isAccessible, "is accessible");
        Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)file2).matches(IResource::exists, "exists");
    }

    @Test
    public void testDelete_1GDW1RX() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        String[] paths = new String[]{"/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, paths);
        ResourceTestUtil.createInWorkspace(resources);
        IFolder folder = project.getFolder("folder");
        ResourceTestUtil.createInFileSystem((IResource)folder);
        IFile file = folder.getFile("MyFile");
        ResourceTestUtil.createInFileSystem((IResource)file);
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> project.delete(false, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testRefreshDotProject() throws Exception {
        String name = ResourceTestUtil.createUniqueString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IFile dotProject = project.getFile(".project");
        project.create(null);
        project.open(null);
        ResourceTestUtil.touchInFilesystem((IResource)dotProject);
        project.refreshLocal(2, null);
        IProjectDescription description = project.getDescription();
        description.setComment("Changed description");
        project.setDescription(description, 0, null);
    }
}

