/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IResourceTest {
    @Test
    public void testAppendContents_1G9RBH5() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        IFile target = project.getFile("file1");
        target.create(ResourceTestUtil.createInputStream("abc"), false, null);
        target.appendContents(ResourceTestUtil.createInputStream("def"), false, true, null);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream content = target.getContents(false);){
            Assertions.assertThat((InputStream)content).hasContent("abcdef");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testBug25686() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder outputFolder = project.getFolder("bin");
        IFile description = project.getFile(".project");
        IFile destination = outputFolder.getFile(".project");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, outputFolder});
        Assertions.assertThat((Object)description).matches(IResource::exists, "exists");
        description.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)destination).matches(IResource::exists, "exists");
    }

    @Test
    public void testBug28790() throws CoreException {
        Assume.assumeTrue((String)"only relevant for platforms supporting archive attribute", (boolean)ResourceTestUtil.isAttributeSupported(8));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("a.txt");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        ResourceAttributes attributes = file.getResourceAttributes();
        attributes.setArchive(false);
        file.setResourceAttributes(attributes);
        Assertions.assertThat((Object)file).matches(it -> !it.getResourceAttributes().isArchive(), "is archive");
        file.setContents(ResourceTestUtil.createRandomContentsStream(), 2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)file).matches(it -> it.getResourceAttributes().isArchive(), "is archive");
    }

    @Test
    public void testBug31750() {
        IResourceProxyVisitor visitor = proxy -> {
            throw new OperationCanceledException();
        };
        org.junit.jupiter.api.Assertions.assertThrows(OperationCanceledException.class, () -> ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0));
    }

    @Test
    public void testBug35991() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("file1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        QualifiedName name = new QualifiedName("test", "testBug35991");
        ResourcesPlugin.getWorkspace().getSynchronizer().add(name);
        ResourcesPlugin.getWorkspace().getSynchronizer().setSyncInfo(name, (IResource)file, new byte[]{1});
        boolean[] seen = new boolean[1];
        boolean[] phantomSeen = new boolean[1];
        AtomicReference<Executable> listenerInMainThreadCallback = new AtomicReference<Executable>(() -> {});
        IResourceChangeListener listener = event -> {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                class DeltaVisitor
                implements IResourceDeltaVisitor {
                    private final boolean[] mySeen;
                    private final /* synthetic */ IFile val$file;

                    DeltaVisitor(boolean[] mySeen, IFile iFile) {
                        this.val$file = iFile;
                        this.mySeen = mySeen;
                    }

                    public boolean visit(IResourceDelta aDelta) {
                        if (aDelta.getResource().equals((Object)this.val$file)) {
                            this.mySeen[0] = true;
                        }
                        return true;
                    }
                }
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor(seen, file));
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor(phantomSeen, file), true);
            }
            catch (CoreException e) {
                listenerInMainThreadCallback.set(() -> {
                    throw e;
                });
            }
        };
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 1);
            ResourcesPlugin.getWorkspace().run(monitor -> {
                ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
                synchronizer.flushSyncInfo(name, (IResource)file, 2);
                synchronizer.setSyncInfo(name, (IResource)file, new byte[]{1});
            }, null, 1, ResourceTestUtil.createTestMonitor());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)seen[0]);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)phantomSeen[0]);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().execute();
    }

    @Test
    public void testBug83777() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testBug83777");
        IFolder folder = project.getFolder("f");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace((IResource)folder);
        folder.setLocal(false, 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(it -> !it.isSynchronized(2), "is synchronized");
    }

    @Test
    public void testBug111821() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testBug111821");
        IFolder folder = project.getFolder((IPath)new Path(null, "c:"));
        ResourceTestUtil.createInWorkspace((IResource)project);
        QualifiedName partner = new QualifiedName("HowdyThere", "Partner");
        ISynchronizer sync = ResourcesPlugin.getWorkspace().getSynchronizer();
        sync.add(partner);
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sync.setSyncInfo(partner, (IResource)folder, new byte[]{1}));
    }

    @Test
    public void testCopy_1GA6QJP() throws CoreException, InterruptedException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile source = project.getFile("file1");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        source.create(ResourceTestUtil.createInputStream("abc"), true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(2000L);
        IPath destinationPath = IPath.fromOSString((String)"copy of file");
        source.copy(destinationPath, true, ResourceTestUtil.createTestMonitor());
        IFile destination = project.getFile(destinationPath);
        long expected = source.getLocation().toFile().lastModified();
        long actual = destination.getLocation().toFile().lastModified();
        long difference = Math.abs(expected - actual);
        org.junit.jupiter.api.Assertions.assertTrue((difference <= 1000L ? 1 : 0) != 0, (String)("time difference>1000ms: " + difference));
    }

    @Test
    public void testCreate_1FW87XF() throws Throwable {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        boolean caseSensitive = new File("abc").compareTo(new File("ABC")) != 0;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("file");
        project.create(null);
        project.open(null);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        Assertions.assertThat((Object)file).matches(IResource::exists, "exists");
        IFile anotherFile = project.getFile("File");
        Executable forcedFileCreation = () -> anotherFile.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        if (caseSensitive) {
            forcedFileCreation.execute();
        } else {
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, (Executable)forcedFileCreation);
        }
        anotherFile.delete(true, false, null);
        Executable fileCreation = () -> anotherFile.create(ResourceTestUtil.createRandomContentsStream(), false, null);
        if (caseSensitive) {
            fileCreation.execute();
        } else {
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, (Executable)fileCreation);
        }
        Executable refresh = () -> anotherFile.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        if (caseSensitive) {
            refresh.execute();
        } else {
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, (Executable)refresh);
        }
    }

    @Test
    public void testCreate_1FWYTKT() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 260) {
            sb.append('a');
            ++i;
        }
        sb.append('b');
        IFolder folder = project.getFolder(sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.create(true, true, null));
        Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "not exists");
        IFile file = project.getFile(sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> file.create(ResourceTestUtil.createRandomContentsStream(), true, null));
        Assertions.assertThat((Object)file).matches(Predicate.not(IResource::exists), "not exists");
        project.delete(true, true, null);
        IProject finalProject = project = ResourcesPlugin.getWorkspace().getRoot().getProject(sb.toString());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> finalProject.create(null));
        Assertions.assertThat((Object)finalProject).matches(Predicate.not(IResource::exists), "not exists");
    }

    @Test
    public void testCreate_1GD7CSU() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        IFile file = project.getFile("MyFile");
        ResourceTestUtil.createInFileSystem((IResource)file);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Disabled(value="This test cannot be done automatically because we don't know in that file system we are running. Will leave test here in case it needs to be run it in a special environment.")
    public void testDelete_1GD3ZUZ() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("MyFile");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        ResourceAttributes attributes = file.getResourceAttributes();
        attributes.setReadOnly(true);
        file.setResourceAttributes(attributes);
        Assertions.assertThat((Object)file).matches(IFile::isReadOnly, "is read-only");
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> file.delete(false, ResourceTestUtil.createTestMonitor()));
        attributes = file.getResourceAttributes();
        attributes.setReadOnly(false);
        file.setResourceAttributes(attributes);
        Assertions.assertThat((Object)file).matches(Predicate.not(IFile::isReadOnly), "is not read-only");
        ResourceTestUtil.removeFromWorkspace(new IResource[]{project, file});
    }

    @Test
    public void testDelete_Bug8754() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("MyFile");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.ensureOutOfSync(file);
        CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> file.delete(false, ResourceTestUtil.createTestMonitor()));
        Object status = exception.getStatus();
        if (status.isMultiStatus()) {
            Object[] children = status.getChildren();
            Assertions.assertThat((Object[])children).hasSize(1);
            status = children[0];
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)274, (int)status.getCode());
        ResourceTestUtil.removeFromWorkspace(new IResource[]{project, file});
    }

    @Test
    public void testEquals_1FUOU25() {
        IFile fileResource = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"a/b/c/d"));
        IFolder folderResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(IPath.fromOSString((String)"a/b/c/d"));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)fileResource, (Object)folderResource);
    }

    @Test
    public void testExists_1FUP8U6() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        project.create(null);
        project.open(null);
        folder.create(true, true, null);
        IFile file = project.getFile("folder");
        Assertions.assertThat((Object)file).matches(Predicate.not(IResource::exists), "not exists");
    }

    @Test
    public void testFindMember_1GA6QYV() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFolder folder1 = project.getFolder("Folder1");
        IFolder folder2 = folder1.getFolder("Folder2");
        IFolder folder3 = folder2.getFolder("Folder3");
        folder1.create(true, true, ResourceTestUtil.createTestMonitor());
        folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        folder3.create(true, true, ResourceTestUtil.createTestMonitor());
        IPath targetPath = IPath.fromOSString((String)"Folder2/Folder3");
        IFolder target = (IFolder)folder1.findMember(targetPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)target, (Object)folder3);
        targetPath = IPath.fromOSString((String)"/Folder2/Folder3");
        target = (IFolder)folder1.findMember(targetPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)target, (Object)folder3);
    }

    @Test
    public void testGetContents_1GBZD4S() throws Throwable {
        InputStream is22;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        IFile target = project.getFile("file1");
        String contents = "some random contents";
        target.create(ResourceTestUtil.createInputStream(contents), false, null);
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            is22 = target.getContents(false);
            try {
                Assertions.assertThat((InputStream)is22).hasContent(contents);
            }
            finally {
                if (is22 != null) {
                    is22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        String newContents = "some other contents";
        Thread.sleep(5000L);
        throwable2 = null;
        is22 = null;
        try (FileOutputStream output = new FileOutputStream(target.getLocation().toFile());){
            ResourceTestUtil.createInputStream("some other contents").transferTo(output);
        }
        catch (Throwable is22) {
            if (throwable2 == null) {
                throwable2 = is22;
            } else if (throwable2 != is22) {
                throwable2.addSuppressed(is22);
            }
            throw throwable2;
        }
        AtomicReference<Executable> listenerInMainThreadCallback = new AtomicReference<Executable>(() -> {});
        IResourceChangeListener listener = event -> listenerInMainThreadCallback.set(() -> org.junit.jupiter.api.Assertions.assertEquals((Object)"some other contents", (Object)target.readString()));
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
            project.touch(null);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().execute();
        CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                InputStream is = target.getContents(false);
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)274, (int)exception.getStatus().getCode());
        Throwable throwable4 = null;
        Object var9_15 = null;
        try (InputStream is = target.getContents(true);){
            Assertions.assertThat((InputStream)is).hasContent("some other contents");
        }
        catch (Throwable throwable5) {
            if (throwable4 == null) {
                throwable4 = throwable5;
            } else if (throwable4 != throwable5) {
                throwable4.addSuppressed(throwable5);
            }
            throw throwable4;
        }
    }

    @Test
    public void testRefreshLocal_1G60AFG() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        project.create(null);
        project.open(null);
        folder.create(true, true, null);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        Assertions.assertThat((Object)file).matches(IResource::exists, "exists");
        folder.refreshLocal(0, null);
        Assertions.assertThat((Object)file).matches(IResource::exists, "exists");
    }

    @Test
    public void testBug553269() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IFolder settingsFolder = project.getFolder(".settings");
        IFile settingsFile = settingsFolder.getFile("org.eclipse.core.resources.prefs");
        project.create(null);
        project.open(null);
        project.setDefaultCharset(StandardCharsets.UTF_8.name(), null);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)settingsFile.exists()).withFailMessage("Preferences saved", new Object[0])).isTrue();
        project.close(null);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        try {
            workspace.addResourceChangeListener((IResourceChangeListener)verifier, 1);
            verifier.addExpectedChange((IResource)project, 4, 16384);
            verifier.addExpectedChange((IResource)settingsFolder, 1, 0);
            verifier.addExpectedChange((IResource)settingsFile, 1, 0);
            verifier.addExpectedChange((IResource)project.getFile(".project"), 1, 0);
            project.open(null);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)verifier.isDeltaValid()).withFailMessage(verifier.getMessage(), new Object[0])).isTrue();
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)verifier);
        }
    }
}

