/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IWorkspaceTest {
    @Test
    public void testMultiMove_1GDKIHD() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file1 = project.getFile("file.txt");
        IFolder folder = project.getFolder("folder");
        IResource[] allResources = new IResource[]{file1, folder};
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().move((IResource[])new IFile[]{file1}, folder.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Object[] states = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        ResourcesPlugin.getWorkspace().delete(allResources, true, ResourceTestUtil.createTestMonitor());
        project.clearHistory(ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().move((IResource[])new IFile[]{file1}, folder.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        states = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        ResourcesPlugin.getWorkspace().delete(allResources, true, ResourceTestUtil.createTestMonitor());
        project.clearHistory(ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testMultiDelete_1GDGRIZ() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file1 = project.getFile("file.txt");
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().delete((IResource[])new IFile[]{file1}, true, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Object[] states = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        ResourcesPlugin.getWorkspace().delete(new IResource[]{file1}, true, ResourceTestUtil.createTestMonitor());
        project.clearHistory(ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().delete((IResource[])new IFile[]{file1}, false, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        states = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        ResourcesPlugin.getWorkspace().delete(new IResource[]{file1}, true, ResourceTestUtil.createTestMonitor());
        project.clearHistory(ResourceTestUtil.createTestMonitor());
        IFolder folder = project.getFolder("folder");
        IFile file2 = folder.getFile("file2.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().delete(new IResource[]{folder}, true, ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        ResourcesPlugin.getWorkspace().delete(new IResource[]{folder, file1, file2}, true, ResourceTestUtil.createTestMonitor());
        project.clearHistory(ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().delete(new IResource[]{folder}, false, ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        ResourcesPlugin.getWorkspace().delete(new IResource[]{folder, file1, file2}, true, ResourceTestUtil.createTestMonitor());
        project.clearHistory(ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void test_8974(@TempDir Path tempDirectory) throws CoreException, IOException {
        IProject one = ResourcesPlugin.getWorkspace().getRoot().getProject("One");
        Path oneTempDirectory = tempDirectory.toRealPath(new LinkOption[0]).resolve(one.getName());
        IPath oneLocation = IPath.fromPath((Path)oneTempDirectory);
        Files.createDirectories(oneTempDirectory, new FileAttribute[0]);
        IProjectDescription oneDescription = ResourcesPlugin.getWorkspace().newProjectDescription(one.getName());
        oneDescription.setLocation(oneLocation);
        one.create(oneDescription, ResourceTestUtil.createTestMonitor());
        IProject two = ResourcesPlugin.getWorkspace().getRoot().getProject("Two");
        IPath twoLocation = oneLocation.removeLastSegments(1).append(oneLocation.lastSegment().toLowerCase());
        IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocation(two, twoLocation);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Workspace.caseSensitive, (Object)result.isOK());
    }
}

