/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class LocalStoreRegressionTests {
    @Test
    public void test_1FU4PJA() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFile file = project.getFile("file");
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assertions.assertThat((Object)file).matches(Predicate.not(IResource::exists), "not exists");
        file.refreshLocal(0, null);
        Assertions.assertThat((Object)file).matches(IResource::exists, "exists");
    }

    @Test
    public void test_1FU4TW7() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)file);
        file.refreshLocal(2, null);
        Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)file).matches(IResource::exists, "exists");
        ResourceTestUtil.removeFromWorkspace((IResource)folder);
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_1G65KR1() throws IOException {
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("" + new Date().getTime());
        File temp = root.toFile();
        temp.mkdirs();
        File target = new File(temp, "target");
        Workspace.clear((File)target);
        Assertions.assertThat((File)target).matches(Predicate.not(File::exists), "not exists");
        try {
            Object var5_7;
            Throwable throwable;
            block28: {
                throwable = null;
                var5_7 = null;
                try {
                    SafeChunkyOutputStream output = new SafeChunkyOutputStream(target);
                    try {
                        try (DataOutputStream dos = new DataOutputStream((OutputStream)output);){
                            dos.writeLong(1234567890L);
                            output.succeed();
                        }
                        if (output == null) break block28;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (output == null) throw throwable;
                        output.close();
                        throw throwable;
                    }
                    output.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            throwable = null;
            var5_7 = null;
            try {
                SafeChunkyInputStream input = new SafeChunkyInputStream(target);
                try {
                    try (DataInputStream dis = new DataInputStream((InputStream)input);){
                        org.junit.jupiter.api.Assertions.assertEquals((long)dis.readLong(), (long)1234567890L);
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        finally {
            ResourceTestUtil.removeFromFileSystem(temp);
        }
    }
}

