/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class NLTest {
    public void getFileNames(List<String> list, char begin, char end) {
        char current = begin;
        int index = 0;
        StringBuilder name = new StringBuilder();
        name.append(current + "_");
        while (current <= end) {
            if (!Character.isLetterOrDigit(current)) {
                current = (char)(current + '\u0001');
                continue;
            }
            name.append(current);
            current = (char)(current + '\u0001');
            if (++index != 10) continue;
            list.add(name.toString());
            index = 0;
            name.setLength(0);
            name.append(current + "_");
        }
        if (name.length() > 0) {
            list.add(name.toString());
        }
    }

    public String[] getFileNames(String language) {
        ArrayList<String> names = new ArrayList<String>(20);
        if (language.equalsIgnoreCase("en")) {
            this.getFileNames(names, 'A', 'Z');
            this.getFileNames(names, 'a', 'z');
        } else if (language.equalsIgnoreCase("ja")) {
            this.getFileNames(names, '\u3040', '\u3093');
            this.getFileNames(names, '\u3095', '\u309f');
            this.getFileNames(names, '\u30a0', '\u30f6');
            this.getFileNames(names, '\u30fb', '\u30ff');
        } else if (language.equalsIgnoreCase("de") || language.equalsIgnoreCase("pt")) {
            this.getFileNames(names, '\u00c0', '\u00ff');
        } else if (language.equalsIgnoreCase("he") || language.equalsIgnoreCase("iw")) {
            this.getFileNames(names, '\u0590', '\u05ff');
        }
        return names.toArray(new String[names.size()]);
    }

    @Test
    public void testFileNames() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        String[] files = this.getFileNames(Locale.ENGLISH.getLanguage());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, files);
        ResourceTestUtil.createInWorkspace(resources);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        ResourceTestUtil.removeFromWorkspace(resources);
        files = this.getFileNames(Locale.getDefault().getLanguage());
        resources = ResourceTestUtil.buildResources((IContainer)project, files);
        ResourceTestUtil.createInWorkspace(resources);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }
}

