/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class PR_1GEAB3C_Test {
    ResourceDeltaVerifier verifier;
    protected static final String VERIFIER_NAME = "TestListener";

    @BeforeEach
    public void setUp() {
        ResourceTestUtil.waitForBuild();
        ResourceTestUtil.waitForRefresh();
        this.verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier);
    }

    @AfterEach
    public void tearDown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
    }

    @Test
    public void test_1GEAB3C() throws CoreException {
        this.verifier.reset();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyAddedAndOpenedProject");
        IFile prefs = project.getFolder(".settings").getFile("org.eclipse.core.resources.prefs");
        this.verifier.addExpectedChange((IResource)project, 1, 16384);
        this.verifier.addExpectedChange((IResource)project.getFile(".project"), 1, 0);
        this.verifier.addExpectedChange(new IResource[]{prefs.getParent()}, 1, 0);
        this.verifier.addExpectedChange(new IResource[]{prefs}, 1, 0);
        IWorkspaceRunnable body = monitor -> {
            monitor.beginTask("Creating and deleting", 100);
            try {
                project.create((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
                project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
            }
            finally {
                monitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
    }
}

