/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestMultipleBuildersOfSameType {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IProject project1;
    private IFolder sorted1;
    private IFolder unsorted1;
    private IFile unsortedFile1;

    @BeforeEach
    public void setUp() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.unsorted1 = this.project1.getFolder(SortBuilder.UNSORTED_FOLDER);
        this.sorted1 = this.project1.getFolder(SortBuilder.SORTED_FOLDER);
        this.unsortedFile1 = this.unsorted1.getFile("File1");
    }

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IResource[] resources = new IResource[]{this.project1, this.unsorted1, this.sorted1, this.unsortedFile1};
        ResourceTestUtil.createInWorkspace(resources);
        this.unsortedFile1.setContents(new byte[]{1, 4, 3}, true, true, null);
        ResourceTestUtil.setAutoBuilding(false);
        ResourceTestUtil.updateProjectDescription(this.project1).addingCommand("org.eclipse.core.tests.resources.sortbuilder").withTestBuilderId("Project1Build1").andCommand("org.eclipse.core.tests.resources.sortbuilder").withTestBuilderId("Project2Build1").apply();
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        SortBuilder[] builders = SortBuilder.allInstances();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])builders).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            Assertions.assertThat((boolean)first.wasBuilt()).isTrue();
            Assertions.assertThat((boolean)first.wasIncrementalBuild()).isTrue();
        }, second -> {
            AbstractBooleanAssert abstractBooleanAssert = Assertions.assertThat((boolean)second.wasAutoBuild()).isFalse();
        }});
    }
}

