/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class Bug_266907 {
    private static final String PROJECT_NAME = "Project";
    private static final String FILE_NAME = "File";
    private static final String MARKER_ATTRIBUTE_NAME = "AttributeName";
    private static final String MARKER_ATTRIBUTE = "Attribute";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1CreateProjectAndDeleteProjectFile() throws Exception {
        Job.getJobManager().suspend();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(PROJECT_NAME);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile f = project.getFile(FILE_NAME);
        f.create(ResourceTestUtil.createInputStream("content"), true, ResourceTestUtil.createTestMonitor());
        IMarker marker = f.createMarker("org.eclipse.core.resources.bookmark");
        marker.setAttribute(MARKER_ATTRIBUTE_NAME, (Object)MARKER_ATTRIBUTE);
        Path dotProject = project.getFile(".project").getLocation().toPath();
        workspace.save(true, ResourceTestUtil.createTestMonitor());
        Path dotProjectCopy = FileSystemHelper.getTempDir().append("dotProjectCopy").toPath();
        Files.copy(dotProject, dotProjectCopy, new CopyOption[0]);
        Files.delete(dotProject);
    }

    @Test
    @Order(value=2)
    public void test2RestoreWorkspaceFile() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(PROJECT_NAME);
        Assertions.assertThat((Object)project).matches(Predicate.not(IResource::isAccessible), "is not accessible");
        Path dotProject = project.getFile(".project").getLocation().toPath();
        Path dotProjectCopy = FileSystemHelper.getTempDir().append("dotProjectCopy").toPath();
        Files.copy(dotProjectCopy, dotProject, new CopyOption[0]);
        Files.delete(dotProjectCopy);
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(IResource::isAccessible, "is accessible");
        IFile file = project.getFile(FILE_NAME);
        Object[] markers = file.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])markers).as("number of markers", new Object[0])).hasSize(1);
        Object attribute = markers[0].getAttribute(MARKER_ATTRIBUTE_NAME);
        ((ObjectAssert)Assertions.assertThat((Object)attribute).as("name of marker", new Object[0])).isEqualTo((Object)MARKER_ATTRIBUTE);
    }
}

