/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class FindDeletedMembersTest {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IWorkspaceRoot root;
    private IProject project;
    private IFile pfile;
    private IFile folderAsFile;
    private IFolder folder;
    private IFile file;
    private IFile file1;
    private IFile file2;
    private IFolder folder2;
    private IFile file3;

    @BeforeEach
    public void setUp() throws Exception {
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = this.root.getProject("MyProject");
        this.pfile = this.project.getFile("file.txt");
        this.folder = this.project.getFolder("folder");
        this.file = this.folder.getFile("file.txt");
        this.folderAsFile = this.project.getFile(this.folder.getProjectRelativePath());
        this.file1 = this.folder.getFile("file1.txt");
        this.file2 = this.folder.getFile("file2.txt");
        this.folder2 = this.folder.getFolder("folder2");
        this.file3 = this.folder2.getFile("file3.txt");
    }

    private void saveWorkspace() throws CoreException {
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=1)
    public void test1() throws Exception {
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.pfile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.pfile.delete(true, true, ResourceTestUtil.createTestMonitor());
        this.saveWorkspace();
    }

    @Test
    @Order(value=2)
    public void test2() throws Exception {
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{this.pfile});
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{this.pfile});
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{this.pfile});
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.pfile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.saveWorkspace();
    }

    @Test
    @Order(value=3)
    public void test3() throws Exception {
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.project.delete(true, ResourceTestUtil.createTestMonitor());
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.folder.create(true, true, ResourceTestUtil.createTestMonitor());
        this.file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.file.delete(true, true, ResourceTestUtil.createTestMonitor());
        this.saveWorkspace();
    }

    @Test
    @Order(value=4)
    public void test4() throws Exception {
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{this.file});
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.folder.delete(true, true, ResourceTestUtil.createTestMonitor());
        this.saveWorkspace();
    }

    @Test
    @Order(value=5)
    public void test5() throws Exception {
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{this.file});
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.folderAsFile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.folderAsFile.delete(true, true, ResourceTestUtil.createTestMonitor());
        this.folder.create(true, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{this.folderAsFile});
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{this.file, this.folderAsFile});
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{this.file, this.folderAsFile});
        this.project.delete(true, ResourceTestUtil.createTestMonitor());
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.folder.create(true, true, ResourceTestUtil.createTestMonitor());
        this.folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.file3.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        this.folder.delete(true, true, ResourceTestUtil.createTestMonitor());
        this.saveWorkspace();
    }

    @Test
    @Order(value=6)
    public void test6() throws Exception {
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{this.file1, this.file2, this.file3});
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{this.file1, this.file2, this.file3});
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).hasSize(2);
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).hasSize(3);
        Assertions.assertThat((Object[])this.folder2.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder2.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).hasSize(1);
        Assertions.assertThat((Object[])this.folder2.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).hasSize(1);
        this.project.delete(true, ResourceTestUtil.createTestMonitor());
        this.saveWorkspace();
    }

    @Test
    @Order(value=7)
    public void test7() throws Exception {
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder2.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder2.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])this.folder2.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        this.saveWorkspace();
    }
}

