/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class ProjectDescriptionDynamicTest {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IProject proj;
    private String[] configNames;
    private IBuildConfiguration[] configs;
    private IProject[] dynRefs;
    private IBuildConfiguration[] configRefs;
    private IProject[] configRefsProjects;

    public IBuildConfiguration getRef(IProject project) {
        return ResourcesPlugin.getWorkspace().newBuildConfig(project.getName(), null);
    }

    public IBuildConfiguration getConfig(IProject project, String id) {
        return ResourcesPlugin.getWorkspace().newBuildConfig(project.getName(), id);
    }

    @BeforeEach
    public void setUp() throws Exception {
        IWorkspaceRoot wr = ResourcesPlugin.getWorkspace().getRoot();
        this.proj = wr.getProject("referencing");
        this.configNames = new String[]{"someConfiguration", "someConfiguration2"};
        this.configs = new IBuildConfiguration[]{this.getConfig(this.proj, "someConfiguration"), this.getConfig(this.proj, "someConfiguration2")};
        this.dynRefs = new IProject[]{wr.getProject("ref1"), wr.getProject("ref2")};
        this.configRefs = new IBuildConfiguration[]{ResourcesPlugin.getWorkspace().newBuildConfig("ref3", "ref3config1"), ResourcesPlugin.getWorkspace().newBuildConfig("ref2", "ref2config1"), ResourcesPlugin.getWorkspace().newBuildConfig("ref1", "ref1config1")};
        this.configRefsProjects = new IProject[]{wr.getProject("ref3"), wr.getProject("ref2"), wr.getProject("ref1")};
    }

    @Test
    @Order(value=1)
    public void test1() throws Exception {
        this.proj.create(ResourceTestUtil.createTestMonitor());
        this.proj.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = this.proj.getDescription();
        desc.setBuildConfigs(this.configNames);
        desc.setDynamicReferences(this.dynRefs);
        this.proj.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws Exception {
        Assertions.assertThat((Object)this.proj).matches(IResource::isAccessible, "is accessible");
        Assertions.assertThat((Object[])this.proj.getDescription().getDynamicReferences()).isEqualTo((Object)this.dynRefs);
        Assertions.assertThat((Object[])this.proj.getBuildConfigs()).isEqualTo((Object)this.configs);
        Assertions.assertThat((Object)this.proj.getActiveBuildConfig()).isEqualTo((Object)this.configs[0]);
        IProjectDescription desc = this.proj.getDescription();
        desc.setBuildConfigReferences(this.configs[1].getName(), this.configRefs);
        desc.setActiveBuildConfig(this.configs[1].getName());
        this.proj.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=3)
    public void test3() throws Exception {
        Assertions.assertThat((Object)this.proj).matches(IResource::isAccessible, "is accessible");
        Assertions.assertThat((Object)this.proj.getActiveBuildConfig()).isEqualTo((Object)this.configs[1]);
        Assertions.assertThat((Object[])this.proj.getDescription().getDynamicReferences()).isEqualTo((Object)this.dynRefs);
        Assertions.assertThat((Object[])this.proj.getReferencedProjects()).isEqualTo((Object)this.configRefsProjects);
        Assertions.assertThat((Object[])this.proj.getDescription().getBuildConfigReferences(this.configs[1].getName())).isEqualTo((Object)this.configRefs);
        IBuildConfiguration[] refs = new IBuildConfiguration[]{this.configRefs[0], this.configRefs[1], this.configRefs[2], this.getRef(this.dynRefs[0]), this.getRef(this.dynRefs[1])};
        Assertions.assertThat((Object[])this.proj.getReferencedBuildConfigs(this.configs[1].getName(), true)).isEqualTo((Object)refs);
        Assertions.assertThat((Object[])this.proj.getReferencedBuildConfigs(this.configs[1].getName(), false)).isEmpty();
    }
}

