/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.osgi.service.prefs.BackingStoreException;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class ProjectPreferenceSessionTest {
    private static final String DIR_NAME = ".settings";
    private static final String FILE_EXTENSION = "prefs";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    private void saveWorkspace() throws Exception {
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=1)
    public void testDeleteFileBeforeLoad1() throws Exception {
        IProject project = ProjectPreferenceSessionTest.getProject("testDeleteFileBeforeLoad");
        String qualifier = "test.delete.file.before.load";
        ResourceTestUtil.createInWorkspace((IResource)project);
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        node.put("key", "value");
        node.flush();
        ResourceTestUtil.waitForRefresh();
        IFile file = project.getFile(IPath.fromOSString((String)DIR_NAME).append(qualifier).addFileExtension(FILE_EXTENSION));
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertTrue((boolean)file.getLocation().toFile().exists());
        this.saveWorkspace();
    }

    @Test
    @Order(value=2)
    public void testDeleteFileBeforeLoad2() throws Exception {
        IProject project = ProjectPreferenceSessionTest.getProject("testDeleteFileBeforeLoad");
        Platform.getPreferencesService().getRootNode().node("project").node(project.getName());
        AtomicReference exceptionInListener = new AtomicReference();
        ILogListener listener = (status, plugin) -> {
            if (!"org.eclipse.core.runtime".equals(plugin)) {
                return;
            }
            Throwable t = status.getException();
            if (t instanceof BackingStoreException) {
                BackingStoreException backingStoreException = (BackingStoreException)t;
                exceptionInListener.set(backingStoreException);
            }
        };
        try {
            Platform.addLogListener((ILogListener)listener);
            project.delete(0, ResourceTestUtil.createTestMonitor());
        }
        finally {
            Platform.removeLogListener((ILogListener)listener);
        }
        if (exceptionInListener.get() != null) {
            throw (BackingStoreException)exceptionInListener.get();
        }
        this.saveWorkspace();
    }

    @Test
    @Order(value=3)
    public void testSaveLoad1() throws Exception {
        IProject project = ProjectPreferenceSessionTest.getProject("testSaveLoad");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("test.save.load");
        node.put("key", "value");
        node.flush();
        this.saveWorkspace();
    }

    @Test
    @Order(value=4)
    public void testSaveLoad2() throws Exception {
        IProject project = ProjectPreferenceSessionTest.getProject("testSaveLoad");
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("test.save.load");
        Assertions.assertEquals((Object)"value", (Object)node.get("key", null));
        this.saveWorkspace();
    }

    private static IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }
}

