/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionShouldError;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class Test1GALH44 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription("MyProject");
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.deltaverifierbuilder");
        description.setBuildSpec(new ICommand[]{command});
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        project.setDescription(description, ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("foo.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @SessionShouldError
    @Order(value=2)
    public void test2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("foo.txt");
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        System.exit(-1);
    }

    @Test
    @Order(value=3)
    public void test3() throws CoreException {
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }
}

