/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug113943 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        IFolder link = project.getFolder("link");
        IFile linkChild = link.getFile("child.txt");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IPath parentLocation = Platform.getLocation().removeLastSegments(1).append("OtherLocation");
        IFileStore parent = EFS.getStore((URI)parentLocation.toFile().toURI());
        IFileStore child = parent.getChild(linkChild.getName());
        parent.mkdir(0, ResourceTestUtil.createTestMonitor());
        child.openOutputStream(0, ResourceTestUtil.createTestMonitor()).close();
        link.createLink(parentLocation, 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)link.exists());
        Assertions.assertTrue((boolean)linkChild.exists());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        IFolder link = project.getFolder("link");
        IFile linkChild = link.getFile("child.txt");
        link.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)link.exists());
        Assertions.assertTrue((boolean)linkChild.exists());
    }
}

