/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug20127 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.setAutoBuilding(false);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.deltaverifierbuilder").withTestBuilderId("Project1Build1").apply();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        IProjectDescription desc = project.getDescription();
        desc.setName("MovedProject");
        project.move(desc, 0, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=3)
    public void test3() throws CoreException {
        IProject oldLocation = ResourcesPlugin.getWorkspace().getRoot().getProject("Project1");
        IProject newLocation = ResourcesPlugin.getWorkspace().getRoot().getProject("MovedProject");
        Assertions.assertFalse((boolean)oldLocation.exists());
        Assertions.assertTrue((boolean)newLocation.exists());
        Assertions.assertTrue((boolean)newLocation.isOpen());
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
    }
}

