/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug202384 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private String testName;

    @BeforeEach
    public void setUpTestName(TestInfo testInfo) {
        this.testName = testInfo.getDisplayName();
    }

    @Test
    @Order(value=1)
    public void testInitializeWorkspace() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        project.setDefaultCharset("UTF-8", ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)"UTF-8", (Object)project.getDefaultCharset(false));
        project.close(ResourceTestUtil.createTestMonitor());
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void testStartWithClosedProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("project");
        Assertions.assertFalse((boolean)project.isOpen());
        Assertions.assertNull((Object)project.getDefaultCharset(false));
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)"UTF-8", (Object)project.getDefaultCharset(false));
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=3)
    public void testStartWithOpenProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("project");
        Assertions.assertTrue((boolean)project.isOpen());
        String expectedEncoding = "UTF-8";
        long timeout = 10000L;
        long start = System.currentTimeMillis();
        while (!expectedEncoding.equals(project.getDefaultCharset(false)) && System.currentTimeMillis() - start < timeout) {
            TestUtil.dumpRunnigOrWaitingJobs(this.testName);
            TestUtil.waitForJobs(this.testName, 500L, 1000L);
        }
        Assertions.assertEquals((Object)expectedEncoding, (Object)project.getDefaultCharset(false));
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }
}

