/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug208833 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project1");
        IFile file = project.getFile("file1.txt");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        workspace.save(true, null);
        Assertions.assertTrue((boolean)project.getLocation().toFile().renameTo(new File(project.getLocation().toFile().getAbsolutePath() + "_temp")));
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject p1 = workspace.getRoot().getProject("Project1");
        Assertions.assertTrue((boolean)p1.exists());
        Assertions.assertFalse((boolean)p1.isOpen());
        Assertions.assertTrue((boolean)new File(p1.getLocation().toFile().getAbsolutePath() + "_temp").renameTo(p1.getLocation().toFile()));
        p1.open(null);
        Assertions.assertTrue((boolean)p1.isOpen());
        IFile file1 = p1.getFile("file1.txt");
        Assertions.assertTrue((boolean)file1.exists());
    }
}

