/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.internal.resources.TestingSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.session.CustomSessionWorkspace;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionShouldError;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug294854 {
    private static final String PROJECT_OLD_NAME = "project_old_name";
    private static final String PROJECT_NEW_NAME = "project_new_name";
    private static final String RESET_WORKSPACE_BEFORE_TAG = "RESET_WORKSPACE";
    private static CustomSessionWorkspace sessionWorkspace = SessionTestExtension.createCustomWorkspace();
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(sessionWorkspace).create();

    private static IProject createProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(PROJECT_OLD_NAME);
        ResourceTestUtil.createInWorkspace((IResource)project);
        Assertions.assertTrue((boolean)project.exists());
        TestingSupport.waitForSnapshot();
        workspace.save(true, ResourceTestUtil.createTestMonitor());
        return project;
    }

    private static boolean checkProjectExists(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return project.exists();
    }

    private static boolean checkProjectIsOpen(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return project.isOpen();
    }

    @BeforeEach
    @ExecuteInHost
    public void resetWorkspace(TestInfo testInfo) throws IOException {
        if (testInfo.getTags().contains(RESET_WORKSPACE_BEFORE_TAG)) {
            Path newWorkspace = Files.createTempDirectory(null, new FileAttribute[0]);
            newWorkspace.toFile().deleteOnExit();
            sessionWorkspace.setWorkspaceDirectory(newWorkspace);
        }
    }

    @Test
    @SessionShouldError
    @Order(value=1)
    public void testRenameUsingProjectDescription_01() throws CoreException, InterruptedException {
        IProject project = TestBug294854.createProject();
        IProjectDescription description = project.getDescription();
        description.setName(PROJECT_NEW_NAME);
        project.move(description, true, ResourceTestUtil.createTestMonitor());
        TestingSupport.waitForSnapshot();
        System.exit(1);
    }

    @Test
    @Order(value=2)
    public void testRenameUsingProjectDescription_02() {
        Assertions.assertFalse((boolean)TestBug294854.checkProjectExists(PROJECT_OLD_NAME));
        Assertions.assertTrue((boolean)TestBug294854.checkProjectExists(PROJECT_NEW_NAME));
    }

    @Test
    @Tag(value="RESET_WORKSPACE")
    @SessionShouldError
    @Order(value=11)
    public void testRenameUsingResourcePath_01() throws CoreException, InterruptedException {
        IProject project = TestBug294854.createProject();
        IPath newLocation = project.getFullPath().removeLastSegments(1).append(PROJECT_NEW_NAME);
        project.move(newLocation, true, ResourceTestUtil.createTestMonitor());
        TestingSupport.waitForSnapshot();
        System.exit(1);
    }

    @Test
    @Order(value=12)
    public void testRenameUsingResourcePath_02() {
        Assertions.assertFalse((boolean)TestBug294854.checkProjectExists(PROJECT_OLD_NAME));
        Assertions.assertTrue((boolean)TestBug294854.checkProjectExists(PROJECT_NEW_NAME));
    }

    @Test
    @Tag(value="RESET_WORKSPACE")
    @SessionShouldError
    @Order(value=21)
    public void testDelete_01() throws CoreException {
        IProject project = TestBug294854.createProject();
        project.delete(true, ResourceTestUtil.createTestMonitor());
        TestingSupport.waitForSnapshot();
        System.exit(1);
    }

    @Test
    @Order(value=22)
    public void testDelete_02() {
        Assertions.assertFalse((boolean)TestBug294854.checkProjectExists(PROJECT_OLD_NAME));
    }

    @Test
    @Tag(value="RESET_WORKSPACE")
    @SessionShouldError
    @Order(value=31)
    public void testDeleteWithoutWaitingForSnapshot_01() throws CoreException {
        IProject project = TestBug294854.createProject();
        IResourceChangeListener selfDeregisteringExistingChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                System.exit(1);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(selfDeregisteringExistingChangeListener, 1);
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=32)
    public void testDeleteWithoutWaitingForSnapshot_02() {
        Assertions.assertTrue((boolean)TestBug294854.checkProjectExists(PROJECT_OLD_NAME));
        Assertions.assertFalse((boolean)TestBug294854.checkProjectIsOpen(PROJECT_OLD_NAME));
    }
}

