/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug30015 {
    private static final String PROJECT_NAME = "Project";
    private static final String VAR_NAME = "ProjectLocatio";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IPath varValue;
    private IPath rawLocation;

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        this.varValue = Platform.getLocation().removeLastSegments(1);
        this.rawLocation = IPath.fromOSString((String)VAR_NAME).append("ProjectLocation");
        ResourcesPlugin.getWorkspace().getPathVariableManager().setValue(VAR_NAME, this.varValue);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(PROJECT_NAME);
        description.setLocation(this.rawLocation);
        project.create(description, ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() {
        this.varValue = Platform.getLocation().removeLastSegments(1);
        this.rawLocation = IPath.fromOSString((String)VAR_NAME).append("ProjectLocation");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        Assertions.assertEquals((Object)this.varValue, (Object)ResourcesPlugin.getWorkspace().getPathVariableManager().getValue(VAR_NAME));
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        Assertions.assertEquals((Object)this.rawLocation, (Object)project.getRawLocation());
        Assertions.assertEquals((Object)this.varValue.append(this.rawLocation.lastSegment()), (Object)project.getLocation());
    }
}

