/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.FileCache;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.CustomSessionWorkspace;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug323833 {
    private static final String READONLY_FILE_NAME = "test";
    private static CustomSessionWorkspace sessionWorkspace = SessionTestExtension.createCustomWorkspace();
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(sessionWorkspace).create();

    @AfterAll
    @ExecuteInHost
    public static void restoreFileWriabilityForCleanup() throws CoreException, IOException {
        Path workspaceDirectory = sessionWorkspace.getWorkspaceDirectory();
        int i = 1;
        while (i <= 2) {
            workspaceDirectory.resolve(READONLY_FILE_NAME + i).toFile().setWritable(true, false);
            ++i;
        }
    }

    @Test
    @Order(value=1)
    void test1_smallFile() throws Exception {
        this.test1(10, "test1");
    }

    @Test
    @Order(value=2)
    void test1_largeFile() throws Exception {
        this.test1(0x10000A, "test2");
    }

    private void test1(int fileSize, String filename) throws Exception {
        if (!Platform.OS.isMac()) {
            return;
        }
        IPath workspaceRootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(workspaceRootLocation).getChild(filename);
        ResourceTestUtil.createInFileSystem(fileStore, fileSize);
        IFileInfo info = fileStore.fetchInfo();
        info.setAttribute(2, true);
        fileStore.putInfo(info, 1024, ResourceTestUtil.createTestMonitor());
        File cachedFile = fileStore.toLocalFile(4096, ResourceTestUtil.createTestMonitor());
        IFileInfo cachedFileInfo = new LocalFile(cachedFile).fetchInfo();
        Assertions.assertTrue((boolean)cachedFileInfo.getAttribute(2));
        Assertions.assertTrue((boolean)cachedFileInfo.getAttribute(0x200000));
    }

    @Test
    @Order(value=3)
    public void test2() throws CoreException {
        if (!Platform.OS.isMac()) {
            return;
        }
        FileCache.getCache();
    }
}

