/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug6995 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ResourceTestUtil.setAutoBuilding(false);
        IProject project = workspace.getRoot().getProject("Project");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.sortbuilder").withTestBuilderId("Project1Build1").apply();
        project.build(6, ResourceTestUtil.createTestMonitor());
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project");
        workspace.save(false, ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("File");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        project.build(10, ResourceTestUtil.createTestMonitor());
        SortBuilder builder = SortBuilder.getInstance();
        Assertions.assertFalse((boolean)builder.wasDeltaNull());
        Assertions.assertTrue((boolean)builder.wasIncrementalBuild());
    }
}

