/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ContentDescriptionManagerTest;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestBug93473 {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1stSession() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ContentDescriptionManagerTest.waitForCacheFlush();
        Assertions.assertEquals((byte)3, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        IProject project = workspace.getRoot().getProject("proj1");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)project);
        Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        IFile file = project.getFile("foo.txt");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        file.getContentDescription();
        ContentDescriptionManagerTest.waitForCacheFlush();
        Assertions.assertEquals((byte)1, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        file.getContentDescription();
        ContentDescriptionManagerTest.waitForCacheFlush();
        Assertions.assertEquals((byte)2, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2ndSession() {
        Assertions.assertEquals((byte)2, (byte)((Workspace)ResourcesPlugin.getWorkspace()).getContentDescriptionManager().getCacheState());
    }
}

