/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestCloseNoSave {
    private static final String PROJECT = "Project";
    private static final String FOLDER = "Folder";
    private static final String FILE = "File";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFolder folder = project.getFolder(FOLDER);
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        IFile file = folder.getFile(FILE);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        Object[] members = ResourcesPlugin.getWorkspace().getRoot().members();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])members).hasSize(1)).allSatisfy(member -> {
            AbstractIntegerAssert abstractIntegerAssert = Assertions.assertThat((int)member.getType()).isEqualTo(4);
        });
        IProject project = (IProject)members[0];
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        IFolder folder = project.getFolder(FOLDER);
        IFile file = folder.getFile(FILE);
        if (!project.isOpen()) {
            project.open(null);
        }
        Assertions.assertThat((Object[])project.members()).hasSize(3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)folder.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.exists());
    }
}

