/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestClosedProjectLocation {
    private static final String PROJECT = "Project";
    private static final String FILE = "File";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IPath location = Platform.getLocation().removeLastSegments(1).append("OtherLocation");

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        IFile file = project.getFile(FILE);
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(PROJECT);
        desc.setLocation(this.location);
        project.create(desc, ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace((IResource)file);
        project.close(ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)this.location, (Object)project.getLocation());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
            IFile file = project.getFile(FILE);
            Assertions.assertTrue((boolean)project.exists());
            Assertions.assertFalse((boolean)project.isOpen());
            Assertions.assertFalse((boolean)file.exists());
            Assertions.assertEquals((Object)this.location, (Object)project.getLocation());
        }
        finally {
            FileSystemHelper.clear((File)this.location.toFile());
        }
    }
}

