/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestInterestingProjectPersistence {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IProject project4;
    private IFile file1;
    private IFile file2;
    private IFile file3;
    private IFile file4;

    @BeforeEach
    public void setUp() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.project2 = root.getProject("Project2");
        this.project3 = root.getProject("Project3");
        this.project4 = root.getProject("Project4");
        this.file1 = this.project1.getFile("File1");
        this.file2 = this.project2.getFile("File2");
        this.file3 = this.project3.getFile("File3");
        this.file4 = this.project4.getFile("File4");
    }

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IResource[] resources = new IResource[]{this.project1, this.project2, this.project3, this.project4, this.file1, this.file2, this.file3, this.file4};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.setAutoBuilding(false);
        ResourceTestUtil.updateProjectDescription(this.project1).addingCommand("org.eclipse.core.tests.resources.deltaverifierbuilder").withTestBuilderId("Project1Build1").apply();
        this.project1.build(6, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        builder.checkDeltas(new IProject[]{this.project1, this.project2, this.project3, this.project4});
        builder.requestDeltas(new IProject[]{this.project1, this.project2, this.project4});
        this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.project1.build(10, ResourceTestUtil.createTestMonitor());
        ArrayList<IProject> received = builder.getReceivedDeltas();
        Assertions.assertThat(received).hasSize(1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)received.contains(this.project1));
        ArrayList<IProject> empty = builder.getEmptyDeltas();
        Assertions.assertThat(empty).isEmpty();
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=3)
    public void test3() throws CoreException {
        DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        builder.checkDeltas(new IProject[]{this.project1, this.project2, this.project3, this.project4});
        this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.file2.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.file3.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.project1.build(10, ResourceTestUtil.createTestMonitor());
        ArrayList<IProject> received = builder.getReceivedDeltas();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)received.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)received.contains(this.project1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)received.contains(this.project2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)received.contains(this.project3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)received.contains(this.project4));
        ArrayList<IProject> empty = builder.getEmptyDeltas();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)empty.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)empty.contains(this.project4));
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }
}

