/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.internal.builders.SnowBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestMissingBuilder {
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    protected boolean hasBuilder(IProject project, String builderId) throws CoreException {
        ICommand[] commands;
        ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected InputStream projectFileWithoutWater() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.core.tests.resources.snowbuilder</name>\n\t\t\t<arguments>\n\t\t\t\t<dictionary>\n\t\t\t\t\t<key>BuildID</key>\n\t\t\t\t\t<value>SnowBuild</value>\n\t\t\t\t</dictionary>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.core.tests.resources.snowNature</nature>\n\t</natures>\n</projectDescription>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.setAutoBuilding(true);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        IFile descFile = project.getFile(".project");
        descFile.setContents(this.projectFileWithoutWater(), 1, ResourceTestUtil.createTestMonitor());
        builder.assertLifecycleEvents();
        Assertions.assertTrue((boolean)this.hasBuilder(project, "org.eclipse.core.tests.resources.snowbuilder"));
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        Assertions.assertTrue((boolean)this.hasBuilder(project, "org.eclipse.core.tests.resources.snowbuilder"));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.assertLifecycleEvents();
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=3)
    public void test3() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        Assertions.assertTrue((boolean)this.hasBuilder(project, "org.eclipse.core.tests.resources.snowbuilder"));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.assertLifecycleEvents();
        ResourceTestUtil.waitForBuild();
        builder.reset();
        builder.addExpectedLifecycleEvent("SnowBuild");
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        Assertions.assertTrue((boolean)builder.wasDeltaNull());
    }
}

