/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestSaveCreateProject {
    private static final String PROJECT = "Project";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Assertions.assertThat((boolean)root.exists()).isTrue();
        Object[] children = root.members();
        ((ObjectAssert)Assertions.assertThat((Object[])children).singleElement().asInstanceOf(InstanceOfAssertFactories.type(IProject.class))).satisfies(new ThrowingConsumer[]{project -> {
            Assertions.assertThat((boolean)project.exists()).isTrue();
            Assertions.assertThat((String)project.getName()).isEqualTo(PROJECT);
        }});
    }
}

