/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestSaveWithClosedProject {
    private static final String PROJECT = "Project";
    private static final String FILE = "File";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        IFile file = project.getFile(FILE);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        project.close(ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        IFile file = project.getFile(FILE);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertFalse((boolean)project.isOpen());
        Assertions.assertFalse((boolean)file.exists());
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)project.isOpen());
        Assertions.assertTrue((boolean)file.exists());
    }
}

