/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestSnapSaveSnap {
    private static final String PROJECT = "Project";
    private static final String FOLDER = "Folder";
    private static final String FILE = "File";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        IFolder folder = project.getFolder(FOLDER);
        IFile file = folder.getFile(FILE);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(false, ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
        byte[] bytes = "Test bytes".getBytes();
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            file.create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ResourcesPlugin.getWorkspace().save(false, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        IFolder folder = project.getFolder(FOLDER);
        IFile file = folder.getFile(FILE);
        Object[] children = ResourcesPlugin.getWorkspace().getRoot().members();
        Assertions.assertThat((Object[])children).containsExactly((Object[])new IResource[]{project});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, folder, file});
    }
}

