/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.harness.session.CustomSessionWorkspace;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestWorkspaceEncodingExistingWorkspace {
    private CustomSessionWorkspace sessionWorkspace = SessionTestExtension.createCustomWorkspace();
    @RegisterExtension
    SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(this.sessionWorkspace).create();

    @BeforeEach
    @ExecuteInHost
    public void setUpWorkspace() throws IOException {
        Path projectsTree = this.sessionWorkspace.getWorkspaceDirectory().resolve(".metadata/.plugins/org.eclipse.core.resources/.projects");
        Files.createDirectories(projectsTree, new FileAttribute[0]);
    }

    @Test
    public void testExpectedEncoding1() throws Exception {
        String defaultValue = System.getProperty("native.encoding");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Assertions.assertEquals((Object)Charset.forName(defaultValue), (Object)Charset.forName(ResourcesPlugin.getEncoding()));
        Assertions.assertEquals((Object)Charset.forName(defaultValue), (Object)Charset.forName(workspace.getRoot().getDefaultCharset(true)));
        String charset = workspace.getRoot().getDefaultCharset(false);
        Assertions.assertEquals(null, (Object)charset);
    }
}

