/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class TestWorkspaceEncodingNewWorkspace {
    private static final String CHARSET = "UTF-16";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void testExpectedEncoding1() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String charset = workspace.getRoot().getDefaultCharset(false);
        Assertions.assertEquals((Object)"UTF-8", (Object)charset);
        workspace.getRoot().setDefaultCharset(CHARSET, ResourceTestUtil.createTestMonitor());
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void testExpectedEncoding2() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String charset = workspace.getRoot().getDefaultCharset(false);
        Assertions.assertEquals((Object)CHARSET, (Object)charset);
    }
}

