/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestWorkspaceEncodingWithJvmArgs {
    private static final String CHARSET = "UTF-16";
    @RegisterExtension
    SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @BeforeEach
    @ExecuteInHost
    public void setUpSession() {
        this.sessionTestExtension.setSystemProperty("file.encoding", CHARSET);
    }

    @Test
    public void testExpectedEncoding() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Assertions.assertEquals((Object)CHARSET, (Object)ResourcesPlugin.getEncoding());
        Assertions.assertEquals((Object)CHARSET, (Object)workspace.getRoot().getDefaultCharset(true));
        String charset = workspace.getRoot().getDefaultCharset(false);
        Assertions.assertEquals((Object)CHARSET, (Object)charset);
    }
}

