/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestWorkspaceEncodingWithPluginCustomization {
    private static final String CHARSET = "UTF-16";
    private static final String FILE_NAME = FileSystemHelper.getTempDir().append("plugin_customization_encoding.ini").toOSString();
    @RegisterExtension
    SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @BeforeEach
    @ExecuteInHost
    public void setUpSession() throws IOException {
        File file = new File(FILE_NAME);
        file.deleteOnExit();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("org.eclipse.core.resources/encoding=UTF-16");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.sessionTestExtension.setEclipseArgument("pluginCustomization", file.toString());
    }

    @Test
    public void testExpectedEncoding() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Assertions.assertEquals((Object)CHARSET, (Object)ResourcesPlugin.getEncoding());
        Assertions.assertEquals((Object)CHARSET, (Object)workspace.getRoot().getDefaultCharset(true));
        String charset = workspace.getRoot().getDefaultCharset(false);
        Assertions.assertEquals((Object)CHARSET, (Object)charset);
    }
}

