/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class WorkspaceDescriptionTest {
    private static final String[] BUILD_ORDER = new String[]{"Foo"};
    private static final boolean APPLY_POLICY = false;
    private static final long STATE_LONGEVITY = 123456L;
    private static final int MAX_STATES = 244;
    private static final long MAX_FILE_SIZE = 54272L;
    private static final long SNAPSHOT_INTERVAL = 4321L;
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources").withCustomization(SessionTestExtension.createCustomWorkspace()).create();

    @Test
    @Order(value=1)
    public void test1() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(false);
        desc.setBuildOrder(BUILD_ORDER);
        desc.setApplyFileStatePolicy(false);
        desc.setFileStateLongevity(123456L);
        desc.setMaxFileStates(244);
        desc.setMaxFileStateSize(54272L);
        desc.setSnapshotInterval(4321L);
        workspace.setDescription(desc);
        workspace.save(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Order(value=2)
    public void test2() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        Assertions.assertThat((Object)desc).matches(Predicate.not(IWorkspaceDescription::isAutoBuilding), "auto building is disabled");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])desc.getBuildOrder()).as("buildorder in: %s", new Object[]{desc})).isEqualTo((Object)BUILD_ORDER);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)desc.isApplyFileStatePolicy()).as("apply file state policy in: %s", new Object[]{desc})).isEqualTo(false);
        ((AbstractLongAssert)Assertions.assertThat((long)desc.getFileStateLongevity()).as("longevity in: %s", new Object[]{desc})).isEqualTo(123456L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)desc.getMaxFileStates()).as("max states in: %s", new Object[]{desc})).isEqualTo(244);
        ((AbstractLongAssert)Assertions.assertThat((long)desc.getMaxFileStateSize()).as("max file size in: %s", new Object[]{desc})).isEqualTo(54272L);
        ((AbstractLongAssert)Assertions.assertThat((long)desc.getSnapshotInterval()).as("snapshot interval in: %s", new Object[]{desc})).isEqualTo(4321L);
    }
}

