/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.ConcurrentOperation01;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class ConcurrencyTest {
    protected void assertIsNotRunning(ConcurrentOperation01 op) {
        int i = 0;
        while (i < 3) {
            try {
                Thread.sleep(100 * i);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertFalse((boolean)op.isRunning());
            ++i;
        }
    }

    @Test
    public void testConcurrentOperations() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        ConcurrentOperation01 op1 = new ConcurrentOperation01(ResourcesPlugin.getWorkspace());
        ConcurrentOperation01 op2 = new ConcurrentOperation01(ResourcesPlugin.getWorkspace());
        new Thread((Runnable)op1, "op1").start();
        Assertions.assertTrue((boolean)op1.hasStarted());
        op1.returnWhenInSyncPoint();
        Assertions.assertTrue((boolean)op1.isRunning());
        new Thread((Runnable)op2, "op2").start();
        Assertions.assertTrue((boolean)op2.hasStarted());
        this.assertIsNotRunning(op2);
        op1.proceed();
        op2.returnWhenInSyncPoint();
        Assertions.assertTrue((boolean)op2.isRunning());
        op2.proceed();
        Assertions.assertTrue((boolean)op1.getStatus().isOK());
        Assertions.assertTrue((boolean)op2.getStatus().isOK());
        ResourceTestUtil.removeFromWorkspace((IResource)ResourcesPlugin.getWorkspace().getRoot());
    }
}

