/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public abstract class ConcurrentOperation
implements Runnable,
IWorkspaceRunnable {
    protected IWorkspace workspace;
    protected boolean go;
    protected boolean isWaiting;
    protected int hasStarted;
    protected MultiStatus status;
    protected Object startedLock = new Object();
    protected static final int STARTED_NONE = 0;
    protected static final int STARTED_YES = 1;
    protected static final int STARTED_NO = 2;

    public ConcurrentOperation(IWorkspace workspace) {
        this.workspace = workspace;
        this.reset();
    }

    protected abstract void assertRequisites() throws Exception;

    public IStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasStarted() {
        Object object = this.startedLock;
        synchronized (object) {
            while (true) {
                if (this.hasStarted != 0) {
                    return this.hasStarted == 1;
                }
                try {
                    this.startedLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean isReadyToStart() {
        boolean ok = true;
        try {
            this.assertRequisites();
        }
        catch (Exception e) {
            this.logException(e);
            ok = false;
        }
        return ok;
    }

    protected void logException(Exception e) {
        if (e instanceof CoreException) {
            CoreException ce = (CoreException)((Object)e);
            this.status.add(ce.getStatus());
        } else {
            this.status.add((IStatus)new ResourceStatus(0, null, null, (Throwable)e));
        }
    }

    public synchronized void proceed() {
        this.go = true;
        this.notify();
    }

    public void reset() {
        this.go = false;
        this.isWaiting = false;
        this.hasStarted = 0;
        this.status = new MultiStatus("a plugin", 1, "", null);
    }

    public synchronized void returnWhenInSyncPoint() {
        while (!this.isWaiting && this.hasStarted()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        if (this.isReadyToStart()) {
            this.setHasStarted(true);
            try {
                this.workspace.run((IWorkspaceRunnable)this, null);
            }
            catch (Exception e) {
                this.logException(e);
            }
        } else {
            this.setHasStarted(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHasStarted(boolean value) {
        Object object = this.startedLock;
        synchronized (object) {
            this.hasStarted = value ? 1 : 2;
            this.startedLock.notify();
        }
    }

    protected synchronized void syncPoint() {
        this.go = false;
        this.isWaiting = true;
        this.notify();
        while (!this.go) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isWaiting = false;
    }
}

