/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.IResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IFileTest {
    protected void nonexistentFileFailureTests(IFile file, IWorkspace wb) {
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)file).matches(it -> !IResourceTestUtil.isLocal((IResource)it, 0), "is not local")).matches(it -> !IResourceTestUtil.isLocal((IResource)it, 1), "is not local with direct children")).matches(it -> !IResourceTestUtil.isLocal((IResource)it, 2), "is not local with all children");
        IResourceTestUtil.commonFailureTestsForResource((IResource)file, false);
    }

    @Test
    public void testFile() throws CoreException {
        IProgressMonitor monitor = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj = workspace.getRoot().getProject(IResourceTestUtil.PROJECT);
        proj.create(monitor);
        proj.open(monitor);
        IFolder folder = proj.getFolder(IPath.fromOSString((String)IResourceTestUtil.FOLDER));
        IFile file = folder.getFile(IPath.fromOSString((String)IResourceTestUtil.FILE));
        Assertions.assertThat((Object)file).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)file.getWorkspace()).isEqualTo((Object)workspace);
        Assertions.assertThat((Object)file.getProject()).isEqualTo((Object)proj);
        Assertions.assertThat((Object)file.getParent()).isEqualTo((Object)folder);
        Assertions.assertThat((int)file.getType()).isEqualTo(1);
        Assertions.assertThat((Object)file.getFullPath()).isEqualTo((Object)IPath.fromOSString((String)("/" + IResourceTestUtil.PROJECT + "/" + IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FILE)));
        Assertions.assertThat((String)file.getName()).isEqualTo(IResourceTestUtil.FILE);
        Assertions.assertThat((Object)proj.getFolder(IPath.fromOSString((String)IResourceTestUtil.FOLDER))).isEqualTo((Object)folder);
        Assertions.assertThat((Object)workspace.getRoot().getFile(file.getFullPath())).isEqualTo((Object)file);
        IPath projRelativePath = IPath.fromOSString((String)(IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FILE));
        Assertions.assertThat((Object)proj.getFile(projRelativePath)).isEqualTo((Object)file);
        Assertions.assertThat((Object)folder.getFile(IPath.fromOSString((String)IResourceTestUtil.FILE))).isEqualTo((Object)file);
        Assertions.assertThat((Object)file).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
        IPath absolutePath = IPath.fromOSString((String)(proj.getLocation().toOSString() + "/" + IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FILE));
        Assertions.assertThat((Object)file.getLocation()).isEqualTo((Object)absolutePath);
        Assertions.assertThat((Object)file.getProjectRelativePath()).isEqualTo((Object)IPath.fromOSString((String)(IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FILE)));
        folder.create(false, true, monitor);
        Assertions.assertThat((Object)workspace.getRoot().findMember(file.getFullPath())).isNull();
        this.nonexistentFileFailureTests(file, workspace);
        file.create(ResourceTestUtil.createInputStream("0123456789"), false, monitor);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)file).matches(IResource::exists, "exists")).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace")).matches(it -> folder.findMember(it.getName()).exists(), "is contained in folder: " + String.valueOf(folder))).isEqualTo((Object)workspace.getRoot().findMember(file.getFullPath()));
        Assertions.assertThat((Object)file.getLocation()).isEqualTo((Object)absolutePath);
        Assertions.assertThat((Object)file.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isNull();
        file.setSessionProperty(IResourceTestUtil.Q_NAME_SESSION, (Object)IResourceTestUtil.STRING_VALUE);
        Assertions.assertThat((Object)file.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isEqualTo((Object)IResourceTestUtil.STRING_VALUE);
        file.setSessionProperty(IResourceTestUtil.Q_NAME_SESSION, null);
        Assertions.assertThat((Object)file.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isNull();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)file).matches(it -> IResourceTestUtil.isLocal((IResource)it, 0), "is locally available")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 1), "is locally available with direct children")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 2), "is locally available with all children");
        Assertions.assertThat((Object)proj).matches(it -> IResourceTestUtil.isLocal((IResource)it, 0), "is locally available");
        ((ObjectAssert)Assertions.assertThat((Object)folder).matches(it -> IResourceTestUtil.isLocal((IResource)it, 1), "is locally available with direct children")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 2), "is locally available with all children");
        file.delete(false, monitor);
        ((ObjectAssert)Assertions.assertThat((Object)file).matches(Predicate.not(IResource::exists), "does not exist")).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
        Assertions.assertThat((Object[])folder.members()).isEmpty();
        Assertions.assertThat((Object)workspace.getRoot().findMember(file.getFullPath())).isNull();
        Assertions.assertThat((Object)file.getLocation()).isEqualTo((Object)absolutePath);
        this.nonexistentFileFailureTests(file, workspace);
    }
}

