/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.resources.usecase.IResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IFolderTest {
    protected void nonexistentFolderFailureTests(IFolder folder, IContainer parent, IWorkspace workspace) throws CoreException {
        IResource[] members;
        IResourceTestUtil.commonFailureTestsForResource((IResource)folder, false);
        Assertions.assertThat((Object)parent.findMember(folder.getName())).isNull();
        IResource[] iResourceArray = members = parent.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            Assertions.assertThat((String)member.getName()).isNotEqualTo((Object)folder.getName());
            ++n2;
        }
        Assertions.assertThat((Object)folder).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
    }

    @Test
    public void testFolder() throws CoreException {
        IProgressMonitor monitor = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj = workspace.getRoot().getProject(IResourceTestUtil.PROJECT);
        IPath path = IPath.fromOSString((String)IResourceTestUtil.FOLDER);
        IFolder folder = proj.getFolder(path);
        Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)folder.getWorkspace()).isEqualTo((Object)workspace);
        Assertions.assertThat((Object)folder.getProject()).isEqualTo((Object)proj);
        Assertions.assertThat((int)folder.getType()).isEqualTo(2);
        Assertions.assertThat((Object)folder.getFullPath()).isEqualTo((Object)IPath.fromOSString((String)("/" + IResourceTestUtil.PROJECT + "/" + IResourceTestUtil.FOLDER)));
        Assertions.assertThat((String)folder.getName()).isEqualTo(IResourceTestUtil.FOLDER);
        Assertions.assertThat((Object)workspace.getRoot().getFolder(folder.getFullPath())).isEqualTo((Object)folder);
        Assertions.assertThat((Object)proj.getFolder(path)).isEqualTo((Object)folder);
        Assertions.assertThat((Object)folder.getParent()).isEqualTo((Object)proj);
        Assertions.assertThat((Object)folder.getProjectRelativePath()).isEqualTo((Object)IPath.fromOSString((String)IResourceTestUtil.FOLDER));
        proj.create(monitor);
        this.unopenedProjectFailureTests(folder, (IContainer)proj, workspace);
        proj.open(monitor);
        this.nonexistentFolderFailureTests(folder, (IContainer)proj, workspace);
        IPath absolutePath = IPath.fromOSString((String)(proj.getLocation().toOSString() + "/" + IResourceTestUtil.FOLDER));
        Assertions.assertThat((Object)folder.getLocation()).isEqualTo((Object)absolutePath);
        folder.create(false, true, monitor);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder).matches(IResource::exists, "exists")).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace")).matches(it -> workspace.getRoot().findMember(it.getFullPath()).exists(), "is found existing in workspace")).isEqualTo((Object)workspace.getRoot().findMember(folder.getFullPath()));
        Assertions.assertThat((Object)folder.getLocation()).isEqualTo((Object)absolutePath);
        Assertions.assertThat((Object)folder.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isNull();
        folder.setSessionProperty(IResourceTestUtil.Q_NAME_SESSION, (Object)IResourceTestUtil.STRING_VALUE);
        Assertions.assertThat((Object)folder.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isEqualTo((Object)IResourceTestUtil.STRING_VALUE);
        folder.setSessionProperty(IResourceTestUtil.Q_NAME_SESSION, null);
        Assertions.assertThat((Object)folder.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isNull();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder).matches(it -> IResourceTestUtil.isLocal((IResource)it, 0), "is locally available")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 1), "is locally available with direct children")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 2), "is locally available with all children");
        ((ObjectAssert)Assertions.assertThat((Object)proj).matches(it -> IResourceTestUtil.isLocal((IResource)it, 1), "is locally available with direct children")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 2), "is locally available with all children");
        IFolder nestedFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folder.getFullPath().append(IResourceTestUtil.FOLDER));
        Assertions.assertThat((Object)nestedFolder).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)nestedFolder.getWorkspace()).isEqualTo((Object)workspace);
        Assertions.assertThat((Object)nestedFolder.getProject()).isEqualTo((Object)proj);
        Assertions.assertThat((int)nestedFolder.getType()).isEqualTo(2);
        Assertions.assertThat((Object)nestedFolder.getFullPath()).isEqualTo((Object)IPath.fromOSString((String)("/" + IResourceTestUtil.PROJECT + "/" + IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FOLDER)));
        Assertions.assertThat((String)nestedFolder.getName()).isEqualTo(IResourceTestUtil.FOLDER);
        Assertions.assertThat((Object)workspace.getRoot().getFolder(nestedFolder.getFullPath())).isEqualTo((Object)nestedFolder);
        IPath projRelativePath = IPath.fromOSString((String)(IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FOLDER));
        Assertions.assertThat((Object)proj.getFolder(projRelativePath)).isEqualTo((Object)nestedFolder);
        Assertions.assertThat((Object)nestedFolder.getParent()).isEqualTo((Object)folder);
        Assertions.assertThat((Object)nestedFolder.getProjectRelativePath()).isEqualTo((Object)IPath.fromOSString((String)(IResourceTestUtil.FOLDER + "/" + IResourceTestUtil.FOLDER)));
        ((ObjectAssert)Assertions.assertThat((Object)folder).matches(it -> IResourceTestUtil.isLocal((IResource)it, 1), "is locally available with direct children")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 2), "is locally available with all children");
        this.nonexistentFolderFailureTests(nestedFolder, (IContainer)folder, workspace);
        nestedFolder.create(false, true, monitor);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)nestedFolder).matches(IResource::exists, "exists")).matches(it -> folder.findMember(it.getName()).exists(), "is contained in folder: " + String.valueOf(folder))).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace")).matches(it -> workspace.getRoot().findMember(it.getFullPath()).exists(), "is found existing in workspace")).isEqualTo((Object)workspace.getRoot().findMember(nestedFolder.getFullPath()));
        Assertions.assertThat((Object)nestedFolder.getLocation()).isEqualTo((Object)absolutePath.append(IResourceTestUtil.FOLDER));
        nestedFolder.delete(false, monitor);
        Assertions.assertThat((Object)nestedFolder).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object[])folder.members()).isEmpty();
        Assertions.assertThat((Object)workspace.getRoot().findMember(nestedFolder.getFullPath())).isNull();
        Assertions.assertThat((Object)nestedFolder).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
        Assertions.assertThat((Object)nestedFolder.getLocation()).isEqualTo((Object)absolutePath.append(IResourceTestUtil.FOLDER));
        this.nonexistentFolderFailureTests(nestedFolder, (IContainer)folder, workspace);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)folder).matches(IResource::exists, "exists")).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace")).matches(it -> workspace.getRoot().findMember(it.getFullPath()).exists(), "is found existing in workspace")).isEqualTo((Object)workspace.getRoot().findMember(folder.getFullPath()));
        Assertions.assertThat((Object)folder.getLocation()).isEqualTo((Object)absolutePath);
        folder.delete(false, monitor);
        ((ObjectAssert)Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "does not exist")).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
        Assertions.assertThat((Object)workspace.getRoot().findMember(folder.getFullPath())).isNull();
        Assertions.assertThat((Object)folder.getLocation()).isEqualTo((Object)absolutePath);
        this.nonexistentFolderFailureTests(folder, (IContainer)proj, workspace);
    }

    protected void unopenedProjectFailureTests(IFolder folder, IContainer parent, IWorkspace workspace) {
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.create(false, true, null));
        Assertions.assertThat((Object)folder).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
    }
}

