/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.Hashtable;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.resources.usecase.IResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IProjectTest {
    public static String LOCAL_LOCATION_PATH_STRING_0;

    @BeforeEach
    public void setUp() {
        LOCAL_LOCATION_PATH_STRING_0 = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("temp/location0").toOSString();
    }

    protected void commonFailureTests(IProject proj, boolean created) {
        IResourceTestUtil.commonFailureTestsForResource((IResource)proj, created);
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            IProjectDescription iProjectDescription = proj.getDescription();
        });
    }

    protected void nonexistentProjectFailureTests(IProject proj) {
        this.commonFailureTests(proj, false);
        IProgressMonitor monitor = null;
        IWorkspace wb = ResourcesPlugin.getWorkspace();
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> proj.open(monitor));
        Assertions.assertThat((Object)proj).matches(Predicate.not(IProject::isOpen), "is not open");
        org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> proj.getDescription().setLocation(IPath.fromOSString((String)LOCAL_LOCATION_PATH_STRING_0)));
        Assertions.assertThat((Object[])wb.getRoot().getProjects()).isEmpty();
    }

    @Test
    public void testProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProgressMonitor monitor = null;
        IProject proj = workspace.getRoot().getProject(IResourceTestUtil.PROJECT);
        Assertions.assertThat((Object)proj).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)proj.getWorkspace()).isEqualTo((Object)workspace);
        Assertions.assertThat((int)proj.getType()).isEqualTo(4);
        Assertions.assertThat((Object)proj.getFullPath()).isEqualTo((Object)IPath.fromOSString((String)("/" + IResourceTestUtil.PROJECT)));
        Assertions.assertThat((String)proj.getName()).isEqualTo(IResourceTestUtil.PROJECT);
        Assertions.assertThat((Object)proj).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
        Assertions.assertThat((Object)workspace.getRoot().findMember(proj.getFullPath())).isNull();
        Assertions.assertThat((Object)proj.getParent()).isEqualTo((Object)workspace.getRoot());
        Assertions.assertThat((Object)proj.getProject()).isEqualTo((Object)proj);
        Assertions.assertThat((Object)proj.getProjectRelativePath()).isEqualTo((Object)IPath.fromOSString((String)""));
        Assertions.assertThat((Object[])workspace.getRoot().getProjects()).isEmpty();
        this.nonexistentProjectFailureTests(proj);
        proj.create(monitor);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)proj).matches(IResource::exists, "exists")).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace")).matches(it -> workspace.getRoot().findMember(it.getFullPath()).exists(), "is found existing in workspace")).isEqualTo((Object)workspace.getRoot().findMember(proj.getFullPath()))).matches(Predicate.not(IProject::isOpen), "is open");
        this.unopenedProjectFailureTests(proj);
        proj.open(monitor);
        Assertions.assertThat((Object)proj).matches(IProject::isOpen, "is open");
        Assertions.assertThat((Object)proj.getLocation()).isNotNull();
        Assertions.assertThat((Object)proj.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isNull();
        proj.setSessionProperty(IResourceTestUtil.Q_NAME_SESSION, (Object)IResourceTestUtil.STRING_VALUE);
        Assertions.assertThat((Object)proj.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isEqualTo((Object)IResourceTestUtil.STRING_VALUE);
        proj.setSessionProperty(IResourceTestUtil.Q_NAME_SESSION, null);
        Assertions.assertThat((Object)proj.getSessionProperty(IResourceTestUtil.Q_NAME_SESSION)).isNull();
        IProjectDescription desc = proj.getDescription();
        Assertions.assertThat((Object[])desc.getBuildSpec()).isEmpty();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.buildername");
        Object[] commands = new ICommand[]{command};
        Hashtable<String, String> arguments = new Hashtable<String, String>(2);
        arguments.put("param0", "arg0");
        command.setArguments(arguments);
        desc.setBuildSpec((ICommand[])commands);
        Assertions.assertThat((Object[])commands).isEqualTo((Object)desc.getBuildSpec());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)proj).matches(it -> IResourceTestUtil.isLocal((IResource)it, 0), "is locally available")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 1), "is locally available with direct children")).matches(it -> IResourceTestUtil.isLocal((IResource)it, 2), "is locally available with all children");
        proj.close(monitor);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)proj).matches(Predicate.not(IProject::isOpen), "is not open")).matches(IResource::exists, "exists")).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace")).isEqualTo((Object)workspace.getRoot().findMember(proj.getFullPath()));
        this.unopenedProjectFailureTests(proj);
        proj.delete(true, true, monitor);
        Assertions.assertThat((Object)proj).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object[])workspace.getRoot().getProjects()).isEmpty();
        Assertions.assertThat((Object)workspace.getRoot().findMember(proj.getFullPath())).isNull();
        this.nonexistentProjectFailureTests(proj);
        Assertions.assertThat((Object)proj).matches(it -> !workspace.getRoot().exists(it.getFullPath()), "is not contained in workspace");
    }

    protected void unopenedProjectFailureTests(IProject proj) {
        this.commonFailureTests(proj, true);
    }

    protected void unopenedSolutionFailureTests(IProject proj, IWorkspace workspace) {
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> proj.create(null));
        Assertions.assertThat((Object)proj).matches(Predicate.not(IResource::exists), "does not exist");
        Assertions.assertThat((Object)proj).matches(it -> workspace.getRoot().exists(it.getFullPath()), "is contained in workspace");
    }
}

