/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.junit.jupiter.api.Assertions;

final class IResourceTestUtil {
    public static QualifiedName Q_NAME_SESSION = new QualifiedName("prop", "session");
    public static String STRING_VALUE = "value";
    public static String PROJECT = "Project";
    public static String FOLDER = "Folder";
    public static String FILE = "File";

    private IResourceTestUtil() {
    }

    public static void commonFailureTestsForResource(IResource resource, boolean created) {
        String method = "commonFailureTestsForResource(IResource," + (created ? "CREATED" : "NONEXISTENT") + "): ";
        if (!created) {
            Assertions.assertNull((Object)ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath()), (String)(method + "1"));
        }
        Assertions.assertThrows(CoreException.class, () -> {
            Object object = resource.getSessionProperty(Q_NAME_SESSION);
        });
        Assertions.assertThrows(CoreException.class, () -> resource.setSessionProperty(Q_NAME_SESSION, (Object)STRING_VALUE));
    }

    public static boolean isLocal(IResource resource, int depth) {
        return resource.isLocal(depth);
    }
}

