/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class IWorkspaceRunnableUseCaseTest {
    protected IWorkspaceRunnable createRunnable(IProject project, IWorkspaceRunnable nestedOperation, boolean triggerBuild, Exception exceptionToThrow) {
        return monitor -> {
            if (exceptionToThrow != null) {
                if (exceptionToThrow instanceof CoreException) {
                    CoreException ce = (CoreException)((Object)((Object)exceptionToThrow));
                    throw ce;
                }
                if (exceptionToThrow instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)exceptionToThrow;
                    throw re;
                }
                throw new IllegalArgumentException(exceptionToThrow);
            }
            if (triggerBuild) {
                project.touch(ResourceTestUtil.createTestMonitor());
            }
            if (nestedOperation != null) {
                ResourcesPlugin.getWorkspace().run(nestedOperation, ResourceTestUtil.createTestMonitor());
            }
        };
    }

    @Test
    public void testNestedOperationsAndBuilds() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        ResourceTestUtil.setAutoBuilding(true);
        IProjectDescription prjDescription = ResourcesPlugin.getWorkspace().newProjectDescription("MyProject");
        ICommand command = prjDescription.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
        prjDescription.setBuildSpec(new ICommand[]{command});
        project.create(prjDescription, ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project);
        IWorkspaceRunnable op1 = this.createRunnable(project, null, true, null);
        IWorkspaceRunnable op2 = this.createRunnable(project, op1, false, null);
        IWorkspaceRunnable op3 = this.createRunnable(project, op2, false, null);
        builder.reset();
        ResourcesPlugin.getWorkspace().run(op3, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        Assertions.assertTrue((boolean)builder.wasExecuted());
        op1 = this.createRunnable(project, null, true, (Exception)((Object)new OperationCanceledException()));
        op2 = this.createRunnable(project, op1, true, null);
        op3 = this.createRunnable(project, op2, true, null);
        builder.reset();
        Assertions.assertThrows(OperationCanceledException.class, () -> ResourcesPlugin.getWorkspace().run(op3, ResourceTestUtil.createTestMonitor()));
        Assertions.assertFalse((boolean)builder.wasExecuted());
        op1 = this.createRunnable(project, null, true, (Exception)((Object)new CoreException(Status.CANCEL_STATUS)));
        op2 = this.createRunnable(project, op1, true, null);
        op3 = this.createRunnable(project, op2, true, null);
        builder.reset();
        CoreException exception = (CoreException)Assertions.assertThrows(CoreException.class, () -> ResourcesPlugin.getWorkspace().run(op3, ResourceTestUtil.createTestMonitor()));
        Assertions.assertEquals((Object)Status.CANCEL_STATUS, (Object)exception.getStatus());
        Assertions.assertFalse((boolean)builder.wasExecuted());
        op1 = this.createRunnable(project, null, false, null);
        op2 = this.createRunnable(project, op1, false, null);
        op3 = this.createRunnable(project, op2, false, null);
        builder.reset();
        ResourcesPlugin.getWorkspace().run(op3, ResourceTestUtil.createTestMonitor());
        Assertions.assertFalse((boolean)builder.wasExecuted());
    }
}

