/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.junit.jupiter.api.Assertions;

public class Snapshot1Test {
    protected static String[] defineHierarchy1() {
        return new String[]{"/folder110/", "/folder110/folder120/", "/folder110/folder120/folder130/", "/folder110/folder120/folder130/folder140/", "/folder110/folder120/folder130/folder140/folder150/", "/folder110/folder120/folder130/folder140/folder150/file160", "/folder110/folder120/folder130/folder140/file150", "/folder110/folder121/", "/folder110/folder121/folder131/", "/folder110/folder120/folder130/folder141/"};
    }

    protected static String[] defineHierarchy2() {
        return new String[]{"/file110", "/folder110/", "/folder110/file120", "/folder111/", "/folder111/folder120/", "/folder111/file121"};
    }

    public void testCreateMyProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot1Test.defineHierarchy1());
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        project.close(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertFalse((boolean)project.isOpen());
    }

    public void testCreateProject2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        project.create(null);
        project.open(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot1Test.defineHierarchy2());
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    public void testSnapshotWorkspace() throws CoreException {
        ResourcesPlugin.getWorkspace().save(false, null);
    }
}

