/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.Snapshot1Test;
import org.junit.jupiter.api.Assertions;

public class Snapshot2Test {
    protected static String[] defineHierarchy1() {
        ArrayList<String> result = new ArrayList<String>();
        String[] old = Snapshot1Test.defineHierarchy1();
        result.addAll(Arrays.asList(old));
        result.add(IPath.fromOSString((String)"MyProject").append("added file").toString());
        result.add(IPath.fromOSString((String)"MyProject").append("yet another file").toString());
        result.add(IPath.fromOSString((String)"MyProject").append("a folder").addTrailingSeparator().toString());
        return result.toArray(new String[result.size()]);
    }

    protected static String[] defineHierarchy2() {
        return new String[]{"/added file", "/yet another file", "/a folder/"};
    }

    public void testChangeMyProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot2Test.defineHierarchy1());
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    public void testChangeProject2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] children = project.members();
        ResourcesPlugin.getWorkspace().delete(children, true, null);
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot2Test.defineHierarchy2());
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    public void testSnapshotWorkspace() throws CoreException {
        ResourcesPlugin.getWorkspace().save(false, null);
    }

    public void testVerifyPreviousSession() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertFalse((boolean)project.isOpen());
        project.open(null);
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot1Test.defineHierarchy1());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot1Test.defineHierarchy2());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }
}

