/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.Snapshot2Test;

public class Snapshot3Test {
    protected static String[] defineHierarchy1() {
        return Snapshot2Test.defineHierarchy1();
    }

    protected static String[] defineHierarchy2() {
        return Snapshot2Test.defineHierarchy2();
    }

    public void testSaveWorkspace() throws CoreException {
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    public void testVerifyPreviousSession() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot2Test.defineHierarchy1());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        Assertions.assertThat((Object[])project.members()).hasSize(4);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)project.findMember(".project"));
        resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot2Test.defineHierarchy2());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }
}

