/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.Snapshot3Test;

public class Snapshot4Test {
    protected static String[] defineHierarchy1() {
        ArrayList<String> result = new ArrayList<String>();
        String[] old = Snapshot3Test.defineHierarchy1();
        result.addAll(Arrays.asList(old));
        result.remove(IPath.fromOSString((String)"MyProject").append("added file").toString());
        result.remove(IPath.fromOSString((String)"MyProject").append("yet another file").toString());
        result.remove(IPath.fromOSString((String)"MyProject").append("a folder").addTrailingSeparator().toString());
        return result.toArray(new String[result.size()]);
    }

    protected static String[] defineHierarchy2() {
        return new String[0];
    }

    public void testChangeMyProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        IFile file = project.getFile("added file");
        file.delete(true, true, null);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourcesPlugin.getWorkspace().save(true, null);
        file = project.getFile("yet another file");
        file.delete(true, true, null);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourcesPlugin.getWorkspace().save(false, null);
        IFolder folder = project.getFolder("a folder");
        folder.delete(true, true, null);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        ResourcesPlugin.getWorkspace().save(false, null);
    }

    public void testChangeProject2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        project.delete(true, true, null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)project.exists());
        ResourcesPlugin.getWorkspace().save(false, null);
    }

    public void testVerifyPreviousSession() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot3Test.defineHierarchy1());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.isOpen());
        Assertions.assertThat((Object[])project.members()).hasSize(4);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)project.findMember(".project"));
        resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot3Test.defineHierarchy2());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }
}

